<?php  
session_start();
error_reporting(0);
date_default_timezone_set('Asia/Manila');
require_once '../conn.php';

if (strlen($_SESSION['alogin']) == 0) {
    header('location:index.php');
} else {
    // Handle form submission to add or update a banner
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $edit_id = $_POST['edit_id'];
        $desktop_image_new = '';
        $mobile_image_new = '';

        // Upload Desktop Banner
        if (isset($_FILES['desktop_image']['name']) && $_FILES['desktop_image']['name'] != '') {
            $desktop_name = $_FILES['desktop_image']['name'];
            $desktop_tmp = $_FILES['desktop_image']['tmp_name'];
            $desktop_ext = strtolower(pathinfo($desktop_name, PATHINFO_EXTENSION));
            $desktop_image_new = "desktop_" . uniqid() . ".$desktop_ext";
            move_uploaded_file($desktop_tmp, "upload/$desktop_image_new");
        }

        // Upload Mobile Banner
        if (isset($_FILES['mobile_image']['name']) && $_FILES['mobile_image']['name'] != '') {
            $mobile_name = $_FILES['mobile_image']['name'];
            $mobile_tmp = $_FILES['mobile_image']['tmp_name'];
            $mobile_ext = strtolower(pathinfo($mobile_name, PATHINFO_EXTENSION));
            $mobile_image_new = "mobile_" . uniqid() . ".$mobile_ext";
            move_uploaded_file($mobile_tmp, "upload/$mobile_image_new");
        }

        // Update or Insert
        if ($edit_id) {
            $query = "UPDATE banners SET ";
            if ($desktop_image_new) {
                $query .= "desktop_image='$desktop_image_new', ";
            }
            if ($mobile_image_new) {
                $query .= "mobile_image='$mobile_image_new', ";
            }
            $query .= "status=1 WHERE id='$edit_id'";
            $conn->query($query);
        } else {
            $query = "INSERT INTO banners (desktop_image, mobile_image, status) VALUES ('$desktop_image_new', '$mobile_image_new', 1)";
            $conn->query($query);
        }

        header("Location: banners.php");
    }

    // Handle Delete
    if (isset($_GET['delete_id'])) {
        $delete_id = $_GET['delete_id'];
        $query = "SELECT desktop_image, mobile_image FROM banners WHERE id = $delete_id";
        $result = $conn->query($query);
        $row = $result->fetch_assoc();
        unlink("upload/" . $row['desktop_image']);
        unlink("upload/" . $row['mobile_image']);
        $delete_query = "DELETE FROM banners WHERE id = $delete_id";
        $conn->query($delete_query);
        header("Location: banners.php");
    }

    // Fetch latest active banner
    $query = "SELECT * FROM banners WHERE status = 1 ORDER BY id DESC LIMIT 1";
    $result = $conn->query($query);
    $banner = $result->fetch_assoc();

    // Fetch data for editing
    $edit_id = isset($_GET['edit_id']) ? $_GET['edit_id'] : '';
    $edit_data = ["desktop_image" => "", "mobile_image" => ""];
    if ($edit_id) {
        $query = "SELECT * FROM banners WHERE id='$edit_id'";
        $result = $conn->query($query);
        if ($result->num_rows > 0) {
            $edit_data = $result->fetch_assoc();
        }
    }
?>

<!DOCTYPE HTML>
<html>
<head>
   <meta charset="UTF-8" name="viewport" content="width=device-width, initial-scale=1"/>
    <link rel="stylesheet" type="text/css" href="css/bootstrap.css"/>
<title>Manage Banners</title>
     <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="js/jquery-2.1.4.min.js"></script>
    <link href="css/bootstrap.min.css" rel='stylesheet' type='text/css' />
    <link href="css/style.css" rel='stylesheet' type='text/css' />
    <link rel="stylesheet" href="css/morris.css" type="text/css"/>
    <link href="css/font-awesome.css" rel="stylesheet">
    <script type="text/javascript" src="js/jquery.basictable.min.js"></script>
</head>
<body>
<div class="left-content">
    <div class="mother-grid-inner">
              <?php include('includes/header.php');?>
        <?php include('includes/sidebarmenu.php');?>
          <div class="clearfix"> </div>
    </div>

    <div class="container mt-5">
        <h1>Manage Banners</h1>
        <form method="POST" enctype="multipart/form-data">
            <input type="hidden" name="edit_id" value="<?php echo $edit_id; ?>">
            <?php if ($edit_data['desktop_image']) { echo "<img src='upload/{$edit_data['desktop_image']}' width='100'>"; } ?>
            <div class="form-group">
                <label for="desktop_image">Desktop Banner</label>
                <input type="file" name="desktop_image" id="desktop_image" class="form-control">
            </div>
            <?php if ($edit_data['mobile_image']) { echo "<img src='upload/{$edit_data['mobile_image']}' width='100'>"; } ?>
            <div class="form-group">
                <label for="mobile_image">Mobile Banner</label>
                <input type="file" name="mobile_image" id="mobile_image" class="form-control">
            </div>
            <button type="submit" class="btn btn-primary"><?php echo $edit_id ? 'Update' : 'Add'; ?> Banner</button>
        </form>
        <hr>

        <h2>Existing Banners</h2>
        <table class="table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Desktop Image</th>
                    <th>Mobile Image</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $result = $conn->query("SELECT * FROM banners");
                while ($row = $result->fetch_assoc()) {
                    echo "<tr>
                            <td>{$row['id']}</td>
                            <td><img src='upload/{$row['desktop_image']}' width='100'></td>
                            <td><img src='upload/{$row['mobile_image']}' width='100'></td>
                            <td>
                                <a href='banners.php?edit_id={$row['id']}' class='btn btn-warning'>Edit</a>
                                <a href='banners.php?delete_id={$row['id']}' class='btn btn-danger' onclick='return confirm(\"Are you sure?\")'>Delete</a>
                            </td>
                          </tr>";
                }
                ?>
            </tbody>
        </table>
    </div>

    <section style="margin-top:10px;"> 
        <div>
            <?php if ($banner) { ?>
                <a class="" href="#" data-bs-toggle="modal" data-bs-target="#enquire">
                    <img src="upload/<?php echo $banner['desktop_image']; ?>" alt="#" class="desktop-banner" style="width: 100%;">
                    <img src="upload/<?php echo $banner['mobile_image']; ?>" alt="#" class="mobile-banner" style="width: 100%;">
                </a>
            <?php } else { ?>
                <p>No active banners available.</p>
            <?php }} ?>
        </div>
    </section>
</body>
</html>
