<?php
session_start();
error_reporting(E_ALL); // Set error reporting to catch all errors

date_default_timezone_set('Asia/Manila');
require_once '../conn.php';

if (strlen($_SESSION['alogin']) == 0) {
    header('location:index.php');
} else {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $title = $_POST['title'];

        // Check if file is uploaded
        if (isset($_FILES['file_url'])) {
            $fileTmpPath = $_FILES['file_url']['tmp_name'];
            $fileName = $_FILES['file_url']['name'];
            $fileSize = $_FILES['file_url']['size'];
            $fileType = $_FILES['file_url']['type'];
            $fileError = $_FILES['file_url']['error'];

            // Handle upload errors
            if ($fileError !== UPLOAD_ERR_OK) {
                echo "File upload error: " . $fileError;
                exit;
            }

            // Validate file extension (optional)
            $fileNameCmps = explode(".", $fileName);
            $fileExtension = strtolower(end($fileNameCmps));
            $allowedExtensions = array('pdf', 'jpg', 'jpeg', 'png'); // Modify as needed

            if (!in_array($fileExtension, $allowedExtensions)) {
                echo "Only PDF, JPG, PNG files are allowed.";
                exit;
            }

            // Generate a unique name for the uploaded file
            $newFileName = md5(time() . $fileName) . '.' . $fileExtension;
            $uploadFileDir = 'upload/';
            $destPath = $uploadFileDir . $newFileName;

            // Attempt to move uploaded file to the destination folder
            if (move_uploaded_file($fileTmpPath, $destPath)) {
                // File uploaded successfully, insert into the database
                $query = "INSERT INTO brochures (title, file_url) VALUES ('$title', '$destPath')";
                if (mysqli_query($conn, $query)) {
                    echo "<script>alert('File uploaded successfully');</script>";
                    echo "<script>window.location = 'brochures.php';</script>";
                } else {
                    echo "Error inserting into database: " . mysqli_error($conn);
                }
            } else {
                echo "There was an error moving the file. Please check folder permissions.";
            }
        } else {
            echo "No file uploaded.";
        }
    }

 if (isset($_GET['delete_id'])) {
        $delete_id = $_GET['delete_id'];

        // Get the file URL to delete the file from the server
        $result = mysqli_query($conn, "SELECT file_url FROM brochures WHERE id = '$delete_id'");
        $row = mysqli_fetch_assoc($result);
        $file_url = $row['file_url'];

        // Delete the file from the server
        if (file_exists($file_url)) {
            unlink($file_url);  // Delete the file from the server
        }

        // Delete the record from the database
        mysqli_query($conn, "DELETE FROM brochures WHERE id = '$delete_id'") or die(mysqli_error($conn));

        echo "<script>alert('Brochure deleted successfully');</script>";
        echo "<script>window.location = 'brochures.php';</script>"; // Refresh page after deleting
    }
}
?>

<!DOCTYPE HTML>
<html>
<head>
    <meta charset="UTF-8" name="viewport" content="width=device-width, initial-scale=1"/>
    <link rel="stylesheet" type="text/css" href="css/bootstrap.css"/>
    <style>
        .slider-container {
            width: 100%; /* Full width of the viewport */
            margin: 0 auto; /* Center align the content */
        }

        .carousel-inner img {
            width: 100%; /* Full width for the images */
            height: auto; /* Maintain aspect ratio */
        }
    </style>
    <meta charset="UTF-8">    <title>Manage Brochures</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <script type="application/x-javascript"> addEventListener("load", function() { setTimeout(hideURLbar, 0); }, false); function hideURLbar(){ window.scrollTo(0,1); } </script>
    <!-- Bootstrap Core CSS -->
    <link href="css/bootstrap.min.css" rel='stylesheet' type='text/css' />
    <!-- Custom CSS -->
    <link href="css/style.css" rel='stylesheet' type='text/css' />
    <link rel="stylesheet" href="css/morris.css" type="text/css"/>
    <!-- Graph CSS -->
    <link href="css/font-awesome.css" rel="stylesheet"> 
    <!-- jQuery -->
    <script src="js/jquery-2.1.4.min.js"></script>
    <!-- //jQuery -->
    <!-- tables -->
    <link rel="stylesheet" type="text/css" href="css/table-style.css" />
    <link rel="stylesheet" type="text/css" href="css/basictable.css" />
    <script type="text/javascript" src="js/jquery.basictable.min.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#table').basictable();
        });
    </script>
    <!-- //tables -->
    <link href='//fonts.googleapis.com/css?family=Roboto:700,500,300,100italic,100,400' rel='stylesheet' type='text/css'/>
    <link href='//fonts.googleapis.com/css?family=Montserrat:400,700' rel='stylesheet' type='text/css'>
    <!-- lined-icons -->
    <link rel="stylesheet" href="css/icon-font.min.css" type='text/css' />
    <!-- //lined-icons -->
</head>
<body>
<div class="left-content">
    <div class="mother-grid-inner">
        <!--header start here-->
        <?php include('includes/header.php');?>
        <?php include('includes/sidebarmenu.php');?>
        <div class="clearfix"> </div>	
    </div>  <div class="container mt-5">
        <h1>Manage Brochures</h1>
        <form method="POST" enctype="multipart/form-data">
            <div class="form-group">
                <label for="title">Brochure Title</label>
                <input type="text" name="title" id="title" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="file_url">Brochure File</label>
                <input type="file" name="file_url" id="file_url" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-primary">Add Brochure</button>
        </form>
        <hr>
        <h2>Existing Brochures</h2>
        <table class="table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Title</th>
                    <th>File</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $result = mysqli_query($conn, "SELECT * FROM brochures");
                while ($row = mysqli_fetch_assoc($result)) {
                    echo "<tr>
                        <td>{$row['id']}</td>
                        <td>{$row['title']}</td>
                        <td><a href='{$row['file_url']}' target='_blank'>View Brochure</a></td>
                        <td>
                            <a href='brochures.php?delete_id={$row['id']}' class='btn btn-danger' onclick='return confirm(\"Are you sure you want to delete this brochure?\");'>Delete</a>
                        </td>
                    </tr>";
                }
                ?>
            </tbody>
        </table>
         <div class="clearfix"></div>		
							</div>
							<script>
							var toggle = true;
										
							$(".sidebar-icon").click(function() {                
							  if (toggle)
							  {
								$(".page-container").addClass("sidebar-collapsed").removeClass("sidebar-collapsed-back");
								$("#menu span").css({"position":"absolute"});
							  }
							  else
							  {
								$(".page-container").removeClass("sidebar-collapsed").addClass("sidebar-collapsed-back");
								setTimeout(function() {
								  $("#menu span").css({"position":"relative"});
								}, 400);
							  }
											
											toggle = !toggle;
										});
							</script>
    </div>
</body>
</html>
