<?php
session_start();
error_reporting(0);
include('includes/config.php');

if (strlen($_SESSION['alogin']) == 0) {	
    header('location:index.php');
} else {
    $imgid = intval($_GET['imgid']);

    if (isset($_POST['submit'])) {
        $pimage = $_FILES["packageimage"]["name"];
        $targetDir = "pacakgeimages/";
        $targetFile = $targetDir . basename($pimage);

        // Ensure the file is uploaded and moved to the target directory
        if (move_uploaded_file($_FILES["packageimage"]["tmp_name"], $targetFile)) {
            $sql = "UPDATE tbltourpackages SET PackageImage = :pimage WHERE PackageId = :imgid";
            $query = $dbh->prepare($sql);
            $query->bindParam(':imgid', $imgid, PDO::PARAM_STR);
            $query->bindParam(':pimage', $pimage, PDO::PARAM_STR);

            if ($query->execute()) {
                $msg = "Package Image Updated Successfully";
            } else {
                $error = "Database update failed. Please try again.";
            }
        } else {
            $error = "File upload failed. Please ensure the target directory is writable.";
        }
    }
?>
<!DOCTYPE HTML>
<html>
<head>
<title>TMS | Admin Package Creation</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="css/bootstrap.min.css" rel='stylesheet' type='text/css' />
<link href="css/style.css" rel='stylesheet' type='text/css' />
<link rel="stylesheet" href="css/morris.css" type="text/css"/>
<link href="css/font-awesome.css" rel="stylesheet"> 
<script src="js/jquery-2.1.4.min.js"></script>
<style>
    .errorWrap {
        padding: 10px;
        margin: 0 0 20px 0;
        background: #fff;
        border-left: 4px solid #dd3d36;
        box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
    }
    .succWrap {
        padding: 10px;
        margin: 0 0 20px 0;
        background: #fff;
        border-left: 4px solid #5cb85c;
        box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
    }
</style>
</head> 
<body>
<div class="page-container">
    <div class="left-content">
        <div class="mother-grid-inner">
            <?php include('includes/header.php'); ?>
            <div class="clearfix"> </div>	
        </div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.html">Home</a><i class="fa fa-angle-right"></i>Update Package Image</li>
        </ol>
        <div class="grid-form">
            <div class="grid-form1">
                <h3>Update Package Image</h3>
                <?php if ($error) { ?>
                    <div class="errorWrap"><strong>ERROR</strong>: <?php echo htmlentities($error); ?> </div>
                <?php } elseif ($msg) { ?>
                    <div class="succWrap"><strong>SUCCESS</strong>: <?php echo htmlentities($msg); ?> </div>
                <?php } ?>
                <form class="form-horizontal" name="package" method="post" enctype="multipart/form-data">
                    <?php 
                    $sql = "SELECT PackageImage FROM tbltourpackages WHERE PackageId = :imgid";
                    $query = $dbh->prepare($sql);
                    $query->bindParam(':imgid', $imgid, PDO::PARAM_STR);
                    $query->execute();
                    $results = $query->fetchAll(PDO::FETCH_OBJ);
                    if ($query->rowCount() > 0) {
                        foreach ($results as $result) { 
                    ?>
                    <div class="form-group">
                        <label for="focusedinput" class="col-sm-2 control-label">Current Image</label>
                        <div class="col-sm-8">
                            <img src="pacakgeimages/<?php echo htmlentities($result->PackageImage); ?>?<?php echo time(); ?>" width="200">
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="focusedinput" class="col-sm-2 control-label">New Image</label>
                        <div class="col-sm-8">
                            <input type="file" name="packageimage" id="packageimage" required>
                        </div>
                    </div>
                    <?php } } ?>
                    <div class="row">
                        <div class="col-sm-8 col-sm-offset-2">
                            <button type="submit" name="submit" class="btn-primary btn">Update</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <?php include('includes/footer.php'); ?>
    </div>
</div>
<script src="js/bootstrap.min.js"></script>
</body>
</html>
<?php } ?>
