<?php 
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
date_default_timezone_set('Asia/Manila');
require_once '../conn.php';
if(strlen($_SESSION['alogin'])==0) {    
    header('location:index.php');
} 

// Handle Update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_footer'])) {
    $disclaimer = mysqli_real_escape_string($conn, $_POST['disclaimer']);
    $agent_rera = mysqli_real_escape_string($conn, $_POST['agent_rera']);
    $project_rera = mysqli_real_escape_string($conn, $_POST['project_rera']);
    
    $qr_image = '';
    if (isset($_FILES['qr_image']) && $_FILES['qr_image']['error'] == 0) {
        $qr_tmp = $_FILES['qr_image']['tmp_name'];
        $qr_ext = strtolower(pathinfo($_FILES['qr_image']['name'], PATHINFO_EXTENSION));
        $qr_name = time() . '-' . uniqid() . '.' . $qr_ext;
        $qr_path = 'upload/' . $qr_name;
        move_uploaded_file($qr_tmp, $qr_path);
        $qr_image = $qr_path;
    }

    $check = mysqli_query($conn, "SELECT * FROM footer_content LIMIT 1");
    if (mysqli_num_rows($check) > 0) {
        $row = mysqli_fetch_assoc($check);
        $update = "UPDATE footer_content SET disclaimer='$disclaimer', agent_rera='$agent_rera', project_rera='$project_rera'";
        if ($qr_image) {
            $update .= ", qr_image='$qr_image'";
        }
        $update .= " WHERE id='{$row['id']}'";
        mysqli_query($conn, $update);
    } else {
        mysqli_query($conn, "INSERT INTO footer_content (disclaimer, agent_rera, project_rera, qr_image) VALUES ('$disclaimer', '$agent_rera', '$project_rera', '$qr_image')");
    }
}

// Delete Record
if (isset($_GET['delete'])) {
    $delete_id = $_GET['delete'];
    $result = mysqli_query($conn, "SELECT qr_image FROM footer_content WHERE id='$delete_id'");
    $row = mysqli_fetch_assoc($result);
    if (file_exists($row['qr_image'])) unlink($row['qr_image']);
    mysqli_query($conn, "DELETE FROM footer_content WHERE id='$delete_id'");
    header("Location: footer.php");
    exit;
}

$footer = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM footer_content LIMIT 1"));
?>

<!DOCTYPE html>
<!DOCTYPE HTML>
<html>
<head>
    <meta charset="UTF-8" name="viewport" content="width=device-width, initial-scale=1"/>
    <link rel="stylesheet" type="text/css" href="css/bootstrap.css"/>
    <style>
        .slider-container {
            width: 100%;
            margin: 0 auto;
        }

        .carousel-inner img {
            width: 100%;
            height: auto;
        }
    </style>
    <title>Manage Highlights</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <script type="application/x-javascript"> addEventListener("load", function() { setTimeout(hideURLbar, 0); }, false); function hideURLbar(){ window.scrollTo(0,1); } </script>
    <!-- Bootstrap Core CSS -->
    <link href="css/bootstrap.min.css" rel='stylesheet' type='text/css' />
    <!-- Custom CSS -->
    <link href="css/style.css" rel='stylesheet' type='text/css' />
    <link rel="stylesheet" href="css/morris.css" type="text/css"/>
    <link href="css/font-awesome.css" rel="stylesheet"> 
    <script src="js/jquery-2.1.4.min.js"></script>
    <link rel="stylesheet" type="text/css" href="css/table-style.css" />
    <link rel="stylesheet" type="text/css" href="css/basictable.css" />
    <script type="text/javascript" src="js/jquery.basictable.min.js"></script>
</head>
<body>
<div class="left-content">
    <div class="mother-grid-inner">
        <?php include('includes/header.php');?>
        <?php include('includes/sidebarmenu.php');?>

        <div class="clearfix"> </div><div class="container mt-5">
    <h2>Footer Settings</h2>
    <form method="POST" enctype="multipart/form-data">
        <div class="form-group">
            <label>Disclaimer</label>
            <textarea name="disclaimer" class="form-control" rows="4" required><?php echo $footer['disclaimer']; ?></textarea>
        </div>
        <div class="form-group">
            <label>Agent RERA</label>
            <input type="text" name="agent_rera" class="form-control" value="<?php echo $footer['agent_rera']; ?>">
        </div>
        <div class="form-group">
            <label>Project RERA</label>
            <input type="text" name="project_rera" class="form-control" value="<?php echo $footer['project_rera']; ?>">
        </div>
        <div class="form-group">
            <label>QR Code Image</label>
            <input type="file" name="qr_image" class="form-control">
            <?php if (!empty($footer['qr_image'])): ?>
                <img src="<?php echo $footer['qr_image']; ?>" width="100">
            <?php endif; ?>
        </div>
        <button type="submit" name="update_footer" class="btn btn-primary">Save</button>
    </form>

    <hr>
    <h3>Footer Records</h3>
    <table class="table table-bordered">
        <thead>
        <tr>
            <th>ID</th>
            <th>Disclaimer</th>
            <th>Agent RERA</th>
            <th>Project RERA</th>
            <th>QR Image</th>
            <th>Action</th>
        </tr>
        </thead>
        <tbody>
        <?php
        $query = mysqli_query($conn, "SELECT * FROM footer_content");
        while ($row = mysqli_fetch_assoc($query)) {
		?><tr>
                    <td><?php echo $row['id']; ?></td>
                    <td><?php echo $row['disclaimer']; ?></td>
                    <td><?php echo $row['agent_rera']; ?></td>
                    <td><?php echo $row['project_rera']; ?></td>
                    <td><img src='<?php echo $row['qr_image']; ?>' width='80'></td>
                    <td>
                        <a href='footer.php?delete=<?php echo $row['id']; ?>' class='btn btn-danger' onclick=\"return confirm('Delete this entry?')\">Delete</a>
                    </td>
                </tr>
     <?php   }
        ?>
        </tbody>
    </table>
</div>
<script src="js/jquery-3.2.1.min.js"></script>
<script src="js/bootstrap.js"></script>
		  <div class="clearfix"></div>		
							</div>
							<script>
							var toggle = true;
										
							$(".sidebar-icon").click(function() {                
							  if (toggle)
							  {
								$(".page-container").addClass("sidebar-collapsed").removeClass("sidebar-collapsed-back");
								$("#menu span").css({"position":"absolute"});
							  }
							  else
							  {
								$(".page-container").removeClass("sidebar-collapsed").addClass("sidebar-collapsed-back");
								setTimeout(function() {
								  $("#menu span").css({"position":"relative"});
								}, 400);
							  }
											
											toggle = !toggle;
										});
							</script>
                            </body>
</html>
