<?php
session_start();
error_reporting(0);
date_default_timezone_set('Asia/Manila');
require_once '../conn.php';

if (strlen($_SESSION['alogin']) == 0) {
    header('location:index.php');
} else {
    // Handle form submission to add a new gallery image
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $title = $_POST['title'];
        $description = $_POST['description'];

        // Check if an image has been uploaded
        if (isset($_FILES['image']['name']) && $_FILES['image']['name'] != '') {
            // Get file details
            $image_name = $_FILES['image']['name'];
            $image_tmp_name = $_FILES['image']['tmp_name'];
            $image_size = $_FILES['image']['size'];
            $image_error = $_FILES['image']['error'];

            // Define allowed image types and max file size
            $allowed_types = array('image/jpeg', 'image/png', 'image/gif');
            $max_size = 5 * 1024 * 1024; // 5MB

            // Get the file extension
            $image_extension = pathinfo($image_name, PATHINFO_EXTENSION);
            $image_extension = strtolower($image_extension);

            // Check for errors
            if ($image_error === 0) {
                // Check if the file type is allowed
                if (in_array($_FILES['image']['type'], $allowed_types)) {
                    // Check file size
                    if ($image_size <= $max_size) {
                        // Create a unique file name to avoid conflicts
                        $image_new_name = uniqid('', true) . '.' . $image_extension;

                        // Specify the upload directory
                        $upload_dir = 'upload/';

                        // Ensure the upload folder exists
                        if (!is_dir($upload_dir)) {
                            mkdir($upload_dir, 0777, true);
                        }

                        // Move the uploaded file to the upload directory
                        $image_upload_path = $upload_dir . $image_new_name;
                        move_uploaded_file($image_tmp_name, $image_upload_path);

                        // Insert the gallery image details into the database
                        $query = "INSERT INTO gallery (image_url, title, description) VALUES ('$image_upload_path', '$title', '$description')";
                        $conn->query($query);
                        header("Location: gallery.php");
                    } else {
                        echo "<script>alert('File size should not exceed 5MB.');</script>";
                    }
                } else {
                    echo "<script>alert('Invalid file type. Only JPG, PNG, and GIF are allowed.');</script>";
                }
            } else {
                echo "<script>alert('There was an error uploading the file.');</script>";
            }
        } else {
            echo "<script>alert('Please select an image to upload.');</script>";
        }
    }

    // Handle deletion if the delete button is clicked
  if (isset($_GET['delete_id'])) {
        $delete_id = $_GET['delete_id'];

        // Fetch the image URL to delete the file from the server
        $query = "SELECT image_url FROM gallery WHERE id = $delete_id";
        $result = $conn->query($query);
        $row = $result->fetch_assoc();
        $image_url = $row['image_url'];

        // Delete the image file from the server
        if (file_exists($image_url)) {
            unlink($image_url);  // Delete the file
        }

        // Delete the record from the database
        $delete_query = "DELETE FROM gallery WHERE id = $delete_id";
        $conn->query($delete_query);

        // Redirect to the gallery page
        header("Location: gallery.php");
  //  }
}
?>

<!DOCTYPE HTML>
<html>
<head>
    <meta charset="UTF-8" name="viewport" content="width=device-width, initial-scale=1"/>
    <link rel="stylesheet" type="text/css" href="css/bootstrap.css"/>
    <title>Manage Gallery</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="js/jquery-2.1.4.min.js"></script>
    <link href="css/bootstrap.min.css" rel='stylesheet' type='text/css' />
    <link href="css/style.css" rel='stylesheet' type='text/css' />
    <link rel="stylesheet" href="css/morris.css" type="text/css"/>
    <link href="css/font-awesome.css" rel="stylesheet">
    <script type="text/javascript" src="js/jquery.basictable.min.js"></script>
</head>
<body>
<div class="left-content">
    <div class="mother-grid-inner">
        <?php include('includes/header.php');?>
        <?php include('includes/sidebarmenu.php');?>
        <div class="clearfix"> </div>
    </div>

    <div class="container mt-5">
        <h1>Manage Gallery</h1>

        <!-- Form to Add New Gallery Image -->
        <form method="POST" enctype="multipart/form-data">
            <div class="form-group">
                <label for="image">Select Image</label>
                <input type="file" name="image" id="image" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="title">Title</label>
                <input type="text" name="title" id="title" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="description">Description</label>
                <textarea name="description" id="description" class="form-control" rows="3"></textarea>
            </div>
            <button type="submit" class="btn btn-primary">Add Image</button>
        </form>

        <hr>

        <!-- Display Existing Gallery Images -->
        <h2>Existing Gallery Images</h2>
        <table class="table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Image</th>
                    <th>Title</th>
                    <th>Description</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                  <?php
                // Fetch existing gallery images from the database
                $result = $conn->query("SELECT * FROM gallery");
                while ($row = $result->fetch_assoc()) {
                    echo "<tr>
                            <td>{$row['id']}</td>
                            <td><img src='{$row['image_url']}' width='100'></td>
                            <td>{$row['title']}</td>
                            <td>{$row['description']}</td>
                            <td>
                                <a href='gallery.php?delete_id={$row['id']}' class='btn btn-danger' onclick='return confirm(\"Are you sure you want to delete this image?\")'>Delete</a>
                            </td>
                        </tr>";
                }}
                ?>
            </tbody>
        </table>
    </div>
</div>

<script src="js/jquery-3.2.1.min.js"></script>
<script src="js/bootstrap.js"></script>
<div class="clearfix"></div>		
							</div>
							<script>
							var toggle = true;
										
							$(".sidebar-icon").click(function() {                
							  if (toggle)
							  {
								$(".page-container").addClass("sidebar-collapsed").removeClass("sidebar-collapsed-back");
								$("#menu span").css({"position":"absolute"});
							  }
							  else
							  {
								$(".page-container").removeClass("sidebar-collapsed").addClass("sidebar-collapsed-back");
								setTimeout(function() {
								  $("#menu span").css({"position":"relative"});
								}, 400);
							  }
											
											toggle = !toggle;
										});
							</script>
</body>
</html>
