<?php
session_start();
error_reporting(E_ALL);  // Enable all error reporting
date_default_timezone_set('Asia/Manila');
require_once '../conn.php';

if (strlen($_SESSION['alogin']) == 0) {	
    header('location:index.php');
    exit();
} 

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = mysqli_real_escape_string($conn, $_POST['title']);
    $description = mysqli_real_escape_string($conn, $_POST['description']);

    if (isset($_FILES['icon']) && $_FILES['icon']['error'] == 0) {
        $icon_name = $_FILES['icon']['name'];
        $icon_tmp = $_FILES['icon']['tmp_name'];
        $icon_size = $_FILES['icon']['size'];
        $icon_extension = strtolower(pathinfo($icon_name, PATHINFO_EXTENSION));

        // Allowed image formats
        $allowed_extensions = array('jpg', 'jpeg', 'png', 'gif');

        // Extra security: Check MIME type
        $mime_type = mime_content_type($icon_tmp);
        $allowed_mime_types = array('image/jpeg', 'image/png', 'image/gif');

        if (in_array($icon_extension, $allowed_extensions) && in_array($mime_type, $allowed_mime_types)) {
            if ($icon_size <= 5 * 1024 * 1024) { // Max 5MB file size
                $upload_dir = 'upload/';

                // Generate a unique name for the image
                $new_icon_name = time() . '-' . uniqid() . '.' . $icon_extension;
                $upload_path = $upload_dir . $new_icon_name;

                if (move_uploaded_file($icon_tmp, $upload_path)) {
                    // Insert into the database
                    $query = "INSERT INTO highlights (title, description, icon) VALUES ('$title', '$description', '$upload_path')";
                    if (mysqli_query($conn, $query)) {
                        echo "<script>alert('Highlights uploaded');</script>";
                        echo "<script>window.location = 'highlights.php';</script>";
                        exit();
                    } else {
                        echo "<script>alert('Database error: " . mysqli_error($conn) . "');</script>";
                    }
                } else {
                    echo "<script>alert('Error uploading file.');</script>";
                }
            } else {
                echo "<script>alert('File size exceeds 5MB limit.');</script>";
            }
        } else {
            echo "<script>alert('Invalid file type. Only JPG, JPEG, PNG, and GIF are allowed.');</script>";
        }
    } else {
        echo "<script>alert('No file uploaded.');</script>";
    }
}

// Delete Record
if (isset($_GET['delete_id'])) {
    $delete_id = mysqli_real_escape_string($conn, $_GET['delete_id']);

    // Fetch the existing image filename
    $result = mysqli_query($conn, "SELECT icon FROM highlights WHERE id = '$delete_id'");
    if ($row = mysqli_fetch_assoc($result)) {
        $icon_path = 'upload/' . $row['icon'];

        // Delete the file if it exists
        if (file_exists($icon_path)) {
            unlink($icon_path);
        }

        // Delete the record from the database
        mysqli_query($conn, "DELETE FROM highlights WHERE id = '$delete_id'") or die(mysqli_error($conn));
        echo "<script>alert('Highlight deleted');</script>";
        echo "<script>window.location = 'highlights.php';</script>";
        exit();
    }
}
?>




<!DOCTYPE HTML>
<html>
<head>
    <meta charset="UTF-8" name="viewport" content="width=device-width, initial-scale=1"/>
    <link rel="stylesheet" type="text/css" href="css/bootstrap.css"/>
    <style>
        .slider-container {
            width: 100%;
            margin: 0 auto;
        }

        .carousel-inner img {
            width: 100%;
            height: auto;
        }
    </style>
    <title>Manage Highlights</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <script type="application/x-javascript"> addEventListener("load", function() { setTimeout(hideURLbar, 0); }, false); function hideURLbar(){ window.scrollTo(0,1); } </script>
    <!-- Bootstrap Core CSS -->
    <link href="css/bootstrap.min.css" rel='stylesheet' type='text/css' />
    <!-- Custom CSS -->
    <link href="css/style.css" rel='stylesheet' type='text/css' />
    <link rel="stylesheet" href="css/morris.css" type="text/css"/>
    <link href="css/font-awesome.css" rel="stylesheet"> 
    <script src="js/jquery-2.1.4.min.js"></script>
    <link rel="stylesheet" type="text/css" href="css/table-style.css" />
    <link rel="stylesheet" type="text/css" href="css/basictable.css" />
    <script type="text/javascript" src="js/jquery.basictable.min.js"></script>
</head>
<body>
<div class="left-content">
    <div class="mother-grid-inner">
        <?php include('includes/header.php');?>
        <?php include('includes/sidebarmenu.php');?>

        <div class="clearfix"> </div>
    </div>

    <div class="container mt-5">
        <h1>Manage Highlights</h1>

        <!-- Form to Add New Highlight -->
<form method="POST" enctype="multipart/form-data">
    <div class="form-group">
        <label for="title">Highlight Title</label>
        <input type="text" name="title" id="title" class="form-control" required>
    </div>
    <div class="form-group">
        <label for="description">Highlight Description</label>
        <textarea name="description" id="description" class="form-control" rows="3" required></textarea>
    </div>
    <div class="form-group">
        <label for="icon">Upload Icon</label>
        <input type="file" name="icon" id="icon" class="form-control" required>
    </div>
    <button type="submit" class="btn btn-primary">Add Highlight</button>
</form>

        <hr>

        <!-- Display Existing Highlights -->
        <h2>Existing Highlights</h2>
        <table class="table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Title</th>
                    <th>Description</th>
                       <th>Icon</th>
               
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php
                // Fetch existing highlights from the database
                $result = mysqli_query($conn, "SELECT * FROM highlights");
                while ($row = mysqli_fetch_assoc($result)) {
                    echo "<tr>
                            <td>{$row['id']}</td>
                            <td>{$row['title']}</td>
                            <td>{$row['description']}</td>
							<td><img src='{$row['icon']}' width='50'></td>
                           
                            <td>
                                 <a href='highlights.php?delete_id={$row['id']}' class='btn btn-danger' onclick='return confirm(\"Are you sure you want to delete this highlight?\")'>Delete</a>
                            </td>
                        </tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

<script src="js/jquery-3.2.1.min.js"></script>
<script src="js/bootstrap.js"></script>
<div class="clearfix"></div>		
							</div>
							<script>
							var toggle = true;
										
							$(".sidebar-icon").click(function() {                
							  if (toggle)
							  {
								$(".page-container").addClass("sidebar-collapsed").removeClass("sidebar-collapsed-back");
								$("#menu span").css({"position":"absolute"});
							  }
							  else
							  {
								$(".page-container").removeClass("sidebar-collapsed").addClass("sidebar-collapsed-back");
								setTimeout(function() {
								  $("#menu span").css({"position":"relative"});
								}, 400);
							  }
											
											toggle = !toggle;
										});
							</script>
</body>
</html>
