<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once 'conn.php';
if(strlen($_SESSION['alogin'])==0){
    header('location:index.php');
    exit();
} else {

    // ---------------------------
    //  HOSTING SCRIPT FOR NEW DOMAIN CREATION AND HOSTING
    // ---------------------------

    // For debugging: accumulate messages
    $debug = '';

    function debug_log($msg) {
        global $debug;
        $debug .= $msg . "<br>\n";
    }

    // cPanel API Credentials
    $cpanel_user    = "conscient80";
    $cpanel_token   = "WQY2C76JBE5TJB7YRH42LYLNSO5ZHCIT";
    $cpanel_domain  = "conscient80.in";
    $cpanel_api_url = "https://$cpanel_domain:2083/json-api/cpanel";

    // Function to fetch domains from cPanel API
    function get_cpanel_domains() {
        global $cpanel_domain, $cpanel_user, $cpanel_token;
        $api_url = "https://$cpanel_domain:2083/execute/DomainInfo/list_domains";
        $ch = curl_init($api_url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: cpanel $cpanel_user:$cpanel_token"]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        if(curl_errno($ch)){
            echo "<pre>cURL Error: " . curl_error($ch) . "</pre>";
            return [];
        }
        curl_close($ch);
        $data = json_decode($response, true);

        if(isset($data['cpanelresult']['error'])){
             debug_log("cPanel API Error: " . $data['cpanelresult']['error']);
             return [];
        }

        if(isset($data['errors']) || !isset($data['data']['addon_domains'])){
            return [];
        }
        $domains =  array_merge(
            [$data['data']['main_domain']],
            $data['data']['addon_domains'],
            $data['data']['sub_domains'],
            $data['data']['parked_domains']
        );
        $uniqueDomains = array_unique($domains);
        return $uniqueDomains;
    }


    // Recursive function to copy directories and files
    function copyDir($src, $dst) {
        if (!is_dir($src)) {
            return false;
        }
        if (!is_dir($dst)) {
            if(!mkdir($dst, 0755, true)){
                return false;
            }
        }
        $dir = opendir($src);
        while(($file = readdir($dir)) !== false){
            if($file == '.' || $file == '..') continue;
            $srcPath = rtrim($src, '/') . '/' . $file;
            $dstPath = rtrim($dst, '/') . '/' . $file;
            if(is_dir($srcPath)){
                if(!copyDir($srcPath, $dstPath)){
                    return false;
                }
            } else {
                if(!copy($srcPath, $dstPath)){
                    return false;
                }
            }
        }
        closedir($dir);
        return true;
    }

    // If the hosting form is submitted, process it:
    if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['host_company'])){
        $company_id       = $_POST['company_id'];
        $selected_domain  = $_POST['selected_domain'];
        $new_domain_name = trim($_POST['new_domain_name']); // Get the new domain name
        

        // Fetch company details
        $company = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM company_master WHERE id='$company_id'"));
        if(!$company){
            echo "<script>alert('Invalid company selection!');</script>";
            exit();
        }
        debug_log("Company selected: " . $company['company_name']);

        // Convert company name to lowercase without spaces.  Used for folder and db names.
        $company_name = strtolower(str_replace(" ", "", $company['company_name']));
        $root_folder  = "public_html/$company_name";

        // Determine which domain to use
        $new_domain = !empty($new_domain_name) ? $new_domain_name : $selected_domain;
        debug_log("New domain: $new_domain");
        debug_log("Root folder: $root_folder");

        // ---------------------------------------------------------------------
        // Step 1: Create the New Domain (if provided)
        // ---------------------------------------------------------------------
        if (!empty($new_domain_name)) {
            $cpanel_query = http_build_query([
                'cpanel_jsonapi_apiversion' => '2',
                'cpanel_jsonapi_module'     => 'AddonDomain',
                'cpanel_jsonapi_func'       => 'addaddondomain',
                'newdomain'                   => $new_domain_name,
                'dir'                         => $root_folder,
                'subdomain'                   => strtolower(str_replace(".", "", $new_domain_name)), // generates subdomain name
            ]);

            $ch = curl_init("$cpanel_api_url?$cpanel_query");
            curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: cpanel $cpanel_user:$cpanel_token"]);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($ch);
            curl_close($ch);

            $resp_data = json_decode($response, true);

            if (isset($resp_data['cpanelresult']['data'][0]['result']) && $resp_data['cpanelresult']['data'][0]['result'] == 1) {
                debug_log("Domain '$new_domain_name' created successfully.");
            } else {
                debug_log("Failed to create domain '$new_domain_name'. Response: " . htmlspecialchars($response));
                echo "<div style='background:#eee;padding:10px;'>Failed to create domain: " . htmlspecialchars($resp_data['cpanelresult']['error'] ?? 'Unknown error') . "</div>";
                exit(); // Stop execution if domain creation fails
            }
        }



        // ---------------------------------------------------------------------
        // Step 2: Copy Website Files using PHP recursive function
        // ---------------------------------------------------------------------
        $source_folder = "/home/$cpanel_user/public_html/cms.conscient80.in";
        $target_folder = "/home/$cpanel_user/public_html/$company_name";
        debug_log("Source folder: $source_folder");
        debug_log("Target folder: $target_folder");
        if(!is_dir($source_folder)){
            debug_log("Source folder does not exist.");
            echo "<div style='background:#eee;padding:10px;'>$debug</div>";
            exit();
        }
        if(!copyDir($source_folder, $target_folder)){
            debug_log("Failed to copy website files from $source_folder to $target_folder.");
            echo "<div style='background:#eee;padding:10px;'>$debug</div>";
            exit();
        } else {
            debug_log("Website files copied successfully.");
        }

        // ---------------------------------------------------------------------
        // Step 3: Create New Database Dynamically via cPanel API
        // ---------------------------------------------------------------------
        $db_name_with_prefix = $cpanel_user . "_" . $company_name;
        $create_db_url = "https://$cpanel_domain:2083/execute/Mysql/create_database?name=" . urlencode($db_name_with_prefix);
        $ch = curl_init($create_db_url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: cpanel $cpanel_user:$cpanel_token"]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
        $db_result = json_decode($response, true);
        if($db_result && ((isset($db_result['status']) && $db_result['status'] == 1) || (isset($db_result['data']['result']) && $db_result['data']['result'] == 1))){
            $new_db_name = $db_name_with_prefix;
            debug_log("Database $new_db_name created successfully via cPanel API.");
        } else {
            debug_log("Database creation failed via cPanel API. Response: " . htmlspecialchars($response));
            echo "<div style='background:#eee;padding:10px;'>$debug</div>";
            exit();
        }

        // ---------------------------------------------------------------------
        // Step 3.5: Assign Privileges to MySQL User on the New Database
        // Grant ALL privileges on the new database to the user 'conscient80_root'
        // ---------------------------------------------------------------------
        $set_priv_url = "https://$cpanel_domain:2083/execute/Mysql/set_privileges_on_database?user="
                        . urlencode($cpanel_user . "_root")
                        . "&database=" . urlencode($new_db_name)
                        . "&privileges=ALL";
        $ch = curl_init($set_priv_url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: cpanel $cpanel_user:$cpanel_token"]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $priv_response = curl_exec($ch);
        curl_close($ch);
        $priv_result = json_decode($priv_response, true);
        if($priv_result && isset($priv_result['status']) && $priv_result['status'] == 1){
            debug_log("Privileges assigned successfully for user " . $cpanel_user . "_root on database $new_db_name.");
        } else {
            debug_log("Failed to assign privileges via cPanel API. Response: " . htmlspecialchars($priv_response));
            echo "<div style='background:#eee;padding:10px;'>$debug</div>";
            exit();
        }

        // ---------------------------------------------------------------------
        // Step 4: Copy Old Database to New Database using PHP
        // ---------------------------------------------------------------------
        $old_db       = "conscient80_cms";
        $old_db_user  = "conscient80_root";
        $old_db_pass  = "JALPARI@#091";

        // Connect to the old database
        $oldConn = new mysqli('localhost', $old_db_user, $old_db_pass, $old_db);
        if($oldConn->connect_error){
            debug_log("Connection to old database failed: " . $oldConn->connect_error);
            echo "<div style='background:#eee;padding:10px;'>$debug</div>";
            exit();
        }
        debug_log("Connected to old database successfully.");

        // Connect to the new database
        $newConn = new mysqli('localhost', $old_db_user, $old_db_pass, $new_db_name);
        if($newConn->connect_error){
            debug_log("Connection to new database failed: " . $newConn->connect_error);
            echo "<div style='background:#eee;padding:10px;'>$debug</div>";
            exit();
        }
        debug_log("Connected to new database successfully.");

        // Get list of tables from the old database
        $tablesResult = $oldConn->query("SHOW TABLES");
        if(!$tablesResult){
            debug_log("Failed to retrieve tables from old database: " . $oldConn->error);
            echo "<div style='background:#eee;padding:10px;'>$debug</div>";
            exit();
        }

        while($row = $tablesResult->fetch_array()){
            $table = $row[0];
            debug_log("Processing table: $table");
            // Get the CREATE TABLE statement for this table
            $createResult = $oldConn->query("SHOW CREATE TABLE `$table`");
            if(!$createResult){
                debug_log("Failed to get CREATE statement for table $table: " . $oldConn->error);
                continue;
            }
            $createRow = $createResult->fetch_assoc();
            $createTableSQL = $createRow['Create Table'];
            // Create the table in the new database
            if(!$newConn->query($createTableSQL)){
                debug_log("Failed to create table $table in new database: " . $newConn->error);
                continue;
            } else {
                debug_log("Table $table created successfully in new database.");
            }
            // Copy the data from the old table to the new table
            $dataResult = $oldConn->query("SELECT * FROM `$table`");
            if($dataResult){
                while($dataRow = $dataResult->fetch_assoc()){
                    $columns = array_keys($dataRow);
                    $values  = array_values($dataRow);
                     $escapedValues = array_map(function($value) use ($newConn){
                        if(is_null($value) || $value === ''){
                            return "NULL";
                        }
                        return "'" . $newConn->real_escape_string($value) . "'";
                    }, $values);
                    $insertSQL = "INSERT INTO `$table` (`" . implode("`,`", $columns) . "`) VALUES (" . implode(",", $escapedValues) . ")";
                    if(!$newConn->query($insertSQL)){
                        debug_log("Failed to insert data into table $table: " . $newConn->error);
                    }
                }
                debug_log("Data copied for table $table.");
            } else {
                debug_log("Failed to retrieve data from table $table: " . $oldConn->error);
            }
        }
        $oldConn->close();
        $newConn->close();
        debug_log("Database copied successfully.");

        // ---------------------------------------------------------------------
        // Step 5: Update conn.php with the new Database Name
        // ---------------------------------------------------------------------
        $conn_file = "/home/$cpanel_user/public_html/$company_name/conn.php";
        $new_conn_content = "<?php
\$servername = 'localhost';
\$username = 'conscient80_root';
\$password = 'JALPARI@#091';
\$dbname = '$new_db_name';
\$conn = mysqli_connect(\$servername, \$username, \$password, \$dbname);
if (!\$conn) { die('Connection failed: ' . mysqli_connect_error()); }
?>";
        if(file_put_contents($conn_file, $new_conn_content) === false){
            debug_log("Failed to write the updated conn.php file.");
            echo "<div style='background:#eee;padding:10px;'>$debug</div>";
            exit();
        } else {
            debug_log("conn.php updated successfully.");
        }

        // Generate new config.php content
        $config_path = "/home/$cpanel_user/public_html/$company_name/admin/includes/config.php";
         if (!is_dir(dirname($config_path))) {
            mkdir(dirname($config_path), 0755, true);
            debug_log("Created directory: " . dirname($config_path));
        }
        $config_content = "<?php\n" .
            "define('DB_HOST', 'localhost');\n" .
            "define('DB_USER', 'conscient80_root');\n" .
            "define('DB_PASS', 'JALPARI@#091');\n" .
            "define('DB_NAME', '$new_db_name');\n" .
       "try
{
\$dbh = new PDO(\"mysql:host=\".DB_HOST.\";dbname=\".DB_NAME, DB_USER, DB_PASS, array(PDO::MYSQL_ATTR_INIT_COMMAND => \"SET NAMES 'utf8'\"));
}
catch (PDOException \$e)
{
exit(\"Error: \" . \$e->getMessage());
} \n" .
            "?>";

        // Write updated config.php
        if (file_put_contents($config_path, $config_content) === false) {
            debug_log("Failed to write config.php file.");
            echo $debug;
            exit();
        } else {
            debug_log("config.php updated successfully.");
        }

        debug_log("Company hosted successfully! Access at: http://$new_domain");
        // You can choose to output the debug log immediately or store it for later.
        // For now, we'll output it below the form.
    }
    // ---------------------------
    // END HOSTING PROCESSING CODE
}
?>
<!DOCTYPE HTML>
<html>
<head>
    <meta charset="UTF-8" name="viewport" content="width=device-width, initial-scale=1"/>
    <link rel="stylesheet" type="text/css" href="css/bootstrap.css"/>
    <style>
        .slider-container {
            width: 100%;
            margin: 0 auto;
        }
        .carousel-inner img {
            width: 100%;
            height: auto;
        }
    </style>
    <title>TMS | Master Hosting</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <script type="application/x-javascript">
        addEventListener("load", function() { setTimeout(hideURLbar, 0); }, false);
        function hideURLbar(){ window.scrollTo(0,1); }
    </script>
    <link href="css/bootstrap.min.css" rel='stylesheet' type='text/css' />
    <link href="css/style.css" rel='stylesheet' type='text/css' />
    <link rel="stylesheet" href="css/morris.css" type="text/css"/>
    <link href="css/font-awesome.css" rel="stylesheet">
    <script src="js/jquery-2.1.4.min.js"></script>
    <link rel="stylesheet" type="text/css" href="css/table-style.css" />
    <link rel="stylesheet" type="text/css" href="css/basictable.css" />
    <script type="text/javascript" src="js/jquery.basictable.min.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#table').basictable();
            $('#table-breakpoint').basictable({ breakpoint: 768 });
            $('#table-swap-axis').basictable({ swapAxis: true });
            $('#table-force-off').basictable({ forceResponsive: false });
            $('#table-no-resize').basictable({ noResize: true });
            $('#table-two-axis').basictable();
            $('#table-max-height').basictable({ tableWrapper: true });
        });
    </script>
    <link href='//fonts.googleapis.com/css?family=Roboto:700,500,300,100italic,100,400' rel='stylesheet' type='text/css'/>
    <link href='//fonts.googleapis.com/css?family=Montserrat:400,700' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="css/icon-font.min.css" type='text/css' />
</head>
<body>
    <div class="page-container">
        <div class="left-content">
            <div class="mother-grid-inner">
                <?php include('includes/header.php');?>
                <div class="clearfix"> </div>
            </div>
        <div class="col-md-3"></div>
            <div class="col-md-6 well">
                <h3 class="text-primary">Host a Company</h3>
                <hr style="border-top:1px dotted #ccc;" />
                <form method="POST" action="">
                    <div class="form-group">
                        <label>Select Company</label>
                        <select name="company_id" class="form-control" required>
                            <option value="">-- Select Company --</option>
                            <?php
                            $companies = mysqli_query($conn, "SELECT * FROM company_master");
                            while ($row = mysqli_fetch_assoc($companies)) {
                                echo "<option value='{$row['id']}'>{$row['company_name']}</option>";
                            }
                            ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Select Primary Domain</label>
                        <select  name="selected_domain" id="selected_domain" class="form-control" >
                            <option value="">-- Select Domain --</option>
                            <?php
                           /** $cpanel_domains = get_cpanel_domains();
                            if(!empty($cpanel_domains)){
                                foreach($cpanel_domains as $domain){
                                    echo "<option value='$domain'>$domain</option>";
                                }
                            } else {
                                echo "<option value='' disabled>No domains found</option>";
                            }**/
                            ?>
                        </select>
                    </div>
                     <div class="form-group">
                        <label>Or Create New Domain</label>
                        <input type="text" name="new_domain_name" class="form-control" placeholder="e.g., newdomain.com">
                        <small class="text-muted">Leave blank to use the selected domain.</small>
                    </div>
                    <button type="submit" name="host_company" class="btn btn-primary">Host Company</button>
                </form>
                <?php
                if(isset($debug) && !empty($debug)){
                    echo "<div style='background:#eee;padding:10px;margin-top:15px;'>$debug</div>";
                }
                ?>
            </div>
        </div>
        <?php include('includes/sidebarmenu.php'); ?>
        <div class="clearfix"></div>
    </div>
    <script src="js/jquery-3.2.1.min.js"></script>
    <script src="js/bootstrap.js"></script>
    <script>
        $(document).ready(function() {
            $('#selected_domain').change(function() {
                var selectedValue = $(this).val();
                if (selectedValue === "") {
                    $(this).prop('disabled', true);
                } else {
                    $(this).prop('disabled', false);
                }
            });
        });
    </script>
</body>
</html>
