<?php
session_start();
error_reporting(E_ALL); // Set error reporting to catch all errors

date_default_timezone_set('Asia/Manila');
require_once '../conn.php';

if (strlen($_SESSION['alogin']) == 0) {
    header('location:index.php');
    exit(); // Make sure to exit after header redirection
} else {
    // Handle form submission (Add or Update location)
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Check if we're editing or adding a new location
        if (isset($_POST['edit_id']) && $_POST['edit_id'] != '') {
            // Update location
            $edit_id = $_POST['edit_id'];
            $edit_location = mysqli_real_escape_string($conn, $_POST['edit_location']);
            $edit_map_url = mysqli_real_escape_string($conn, $_POST['edit_map_url']);

            // Update the location in the database
            $query = "UPDATE locations SET location = '$edit_location', map_url = '$edit_map_url' WHERE id = '$edit_id'";

            if (mysqli_query($conn, $query)) {
                echo "<script>alert('Location updated successfully');</script>";
                echo "<script>window.location = 'locations.php';</script>"; // Redirect after success
            } else {
                echo "<script>alert('Error updating location: " . mysqli_error($conn) . "');</script>";
            }
        } else {
            // Add new location
            $location = mysqli_real_escape_string($conn, $_POST['edit_location']);
            $map_url = mysqli_real_escape_string($conn, $_POST['edit_map_url']);

            // Insert new location into the database
            $query = "INSERT INTO locations (location, map_url) VALUES ('$location', '$map_url')";

            if (mysqli_query($conn, $query)) {
                echo "<script>alert('Location added successfully');</script>";
                echo "<script>window.location = 'locations.php';</script>"; // Redirect after success
            } else {
                echo "<script>alert('Error adding location: " . mysqli_error($conn) . "');</script>";
            }
        }
    }

    // Handle Delete action
    if (isset($_GET['delete_id'])) {
        $delete_id = $_GET['delete_id'];
        mysqli_query($conn, "DELETE FROM locations WHERE id = '$delete_id'") or die(mysqli_error($conn));
        echo "<script>alert('Location deleted');</script>";
        echo "<script>window.location = 'locations.php';</script>";
    }

    // Handle Edit action (populate form with data)
    if (isset($_GET['edit_id'])) {
        $edit_id = $_GET['edit_id'];
        $result = mysqli_query($conn, "SELECT * FROM locations WHERE id = '$edit_id'");
        $row = mysqli_fetch_assoc($result);
        $edit_location = $row['location'];
        $edit_map_url = $row['map_url'];
    }

    // Handle Update (Submit the edited data)
 /*   if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit_location']) && isset($_POST['edit_map_url']) && isset($_POST['edit_id'])) {
        $edit_location = $_POST['edit_location'];
        $edit_map_url = $_POST['edit_map_url'];
        $edit_id = $_POST['edit_id'];

        // Update the location
        mysqli_query($conn, "UPDATE locations SET location = '$edit_location', map_url = '$edit_map_url' WHERE id = '$edit_id'") or die(mysqli_error($conn));
        echo "<script>alert('Location updated');</script>";
        echo "<script>window.location = 'locations.php';</script>";
    }*/
?>

<!DOCTYPE HTML>
<html>
<head>
    <meta charset="UTF-8" name="viewport" content="width=device-width, initial-scale=1"/>
    <link rel="stylesheet" type="text/css" href="css/bootstrap.css"/>
    <style>
        .slider-container {
            width: 100%; /* Full width of the viewport */
            margin: 0 auto; /* Center align the content */
        }

        .carousel-inner img {
            width: 100%; /* Full width for the images */
            height: auto; /* Maintain aspect ratio */
        }
    </style>
    <meta charset="UTF-8">
        <title>Manage Locations</title>
   <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <script type="application/x-javascript"> addEventListener("load", function() { setTimeout(hideURLbar, 0); }, false); function hideURLbar(){ window.scrollTo(0,1); } </script>
    <!-- Bootstrap Core CSS -->
    <link href="css/bootstrap.min.css" rel='stylesheet' type='text/css' />
    <!-- Custom CSS -->
    <link href="css/style.css" rel='stylesheet' type='text/css' />
    <link rel="stylesheet" href="css/morris.css" type="text/css"/>
    <!-- Graph CSS -->
    <link href="css/font-awesome.css" rel="stylesheet"> 
    <!-- jQuery -->
    <script src="js/jquery-2.1.4.min.js"></script>
    <!-- //jQuery -->
    <!-- tables -->
    <link rel="stylesheet" type="text/css" href="css/table-style.css" />
    <link rel="stylesheet" type="text/css" href="css/basictable.css" />
    <script type="text/javascript" src="js/jquery.basictable.min.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#table').basictable();
        });
    </script>
    <!-- //tables -->
    <link href='//fonts.googleapis.com/css?family=Roboto:700,500,300,100italic,100,400' rel='stylesheet' type='text/css'/>
    <link href='//fonts.googleapis.com/css?family=Montserrat:400,700' rel='stylesheet' type='text/css'>
    <!-- lined-icons -->
    <link rel="stylesheet" href="css/icon-font.min.css" type='text/css' />
    <!-- //lined-icons -->
</head>
<body>
<div class="left-content">
    <div class="mother-grid-inner">
        <!--header start here-->
        <?php include('includes/header.php'); ?>
        <?php include('includes/sidebarmenu.php'); ?>
        <div class="clearfix"> </div>	
    </div>    <div class="container mt-5">
        <h1>Manage Locations</h1>

        <!-- Form for Adding or Editing Location -->
        <form method="POST">
            <?php if (isset($edit_id)): ?>
                <h2>Edit Location</h2>
                <input type="hidden" name="edit_id" value="<?php echo $edit_id; ?>" />
            <?php else: ?>
                <h2>Add New Location</h2>
            <?php endif; ?>

            <div class="form-group">
                <label for="edit_location">Location Description</label>
                <textarea name="edit_location" id="edit_location" class="form-control" required><?php echo isset($edit_location) ? $edit_location : ''; ?></textarea>
            </div>
            <div class="form-group">
                <label for="edit_map_url">Google Map URL</label>
                <input type="text" name="edit_map_url" id="edit_map_url" class="form-control" required value="<?php echo isset($edit_map_url) ? $edit_map_url : ''; ?>">
            </div>
            <button type="submit" class="btn btn-primary"><?php echo isset($edit_id) ? 'Update Location' : 'Add Location'; ?></button>
        </form>
        <hr>

        <!-- Existing Locations Table -->
        <h2>Existing Locations</h2>
        <table class="table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Location</th>
                    <th>Map</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php
            $result = mysqli_query($conn, "SELECT * FROM locations");
            while ($row = mysqli_fetch_assoc($result)) {
                echo "<tr>
                        <td>{$row['id']}</td>
                        <td>{$row['location']}</td>
                        <td><a href='{$row['map_url']}' target='_blank'>View Map</a></td>
                        <td>
                            <a href='locations.php?edit_id={$row['id']}' class='btn btn-warning'>Edit</a>
                            <a href='locations.php?delete_id={$row['id']}' class='btn btn-danger' onclick='return confirm(\"Are you sure you want to delete this location?\");'>Delete</a>
                        </td>
                    </tr>";
            }
            ?>
            </tbody>
        </table>
    </div>
</div>

<script src="js/jquery-3.2.1.min.js"></script>
<script src="js/bootstrap.js"></script>
		  <div class="clearfix"></div>		
							</div>
							<script>
							var toggle = true;
										
							$(".sidebar-icon").click(function() {                
							  if (toggle)
							  {
								$(".page-container").addClass("sidebar-collapsed").removeClass("sidebar-collapsed-back");
								$("#menu span").css({"position":"absolute"});
							  }
							  else
							  {
								$(".page-container").removeClass("sidebar-collapsed").addClass("sidebar-collapsed-back");
								setTimeout(function() {
								  $("#menu span").css({"position":"relative"});
								}, 400);
							  }
											
											toggle = !toggle;
										});
							</script>
</body>
</html>

<?php } ?>
