<?php 
session_start();
error_reporting(0);
date_default_timezone_set('Asia/Manila');
require_once '../conn.php';

if (strlen($_SESSION['alogin']) == 0) {
    header('location:index.php');
} else {
    // Handle form submission to add or update a gallery image
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $title = $_POST['title'];
        $description = $_POST['description'];
        $edit_id = $_POST['edit_id'];
        $image_new_name = '';

        // Check if an image has been uploaded
        if (isset($_FILES['image']['name']) && $_FILES['image']['name'] != '') {
            $image_name = $_FILES['image']['name'];
            $image_tmp_name = $_FILES['image']['tmp_name'];
            $image_size = $_FILES['image']['size'];
            $image_error = $_FILES['image']['error'];

            $allowed_types = array('image/jpeg', 'image/png', 'image/gif');
            $max_size = 5 * 1024 * 1024; // 5MB

            $image_extension = pathinfo($image_name, PATHINFO_EXTENSION);
            $image_extension = strtolower($image_extension);

            if ($image_error === 0) {
                if (in_array($_FILES['image']['type'], $allowed_types)) {
                    if ($image_size <= $max_size) {
                        $image_new_name = uniqid('', true) . '.' . $image_extension;
                        $upload_dir = 'upload/';
                        if (!is_dir($upload_dir)) {
                            mkdir($upload_dir, 0777, true);
                        }
                        $image_upload_path = $upload_dir . $image_new_name;
                        move_uploaded_file($image_tmp_name, $image_upload_path);
                    } else {
                        echo "<script>alert('File size should not exceed 5MB.');</script>";
                    }
                } else {
                    echo "<script>alert('Invalid file type. Only JPG, PNG, and GIF are allowed.');</script>";
                }
            } else {
                echo "<script>alert('There was an error uploading the file.');</script>";
            }
        }

        if ($edit_id) {
            // Update query
            $query = "UPDATE overviews SET title='$title', description='$description'";
            if ($image_new_name) {
                $query .= ", image_url='$image_upload_path'";
            }
            $query .= " WHERE id='$edit_id'";
            $conn->query($query);
        } else {
            // Insert query
            if ($image_new_name) {
                $query = "INSERT INTO overviews (image_url, title, description) VALUES ('$image_upload_path', '$title', '$description')";
                $conn->query($query);
            } else {
                echo "<script>alert('Please select an image to upload.');</script>";
            }
        }
        header("Location: overviews.php");
    }

    // Handle delete
    if (isset($_GET['delete_id'])) {
        $delete_id = $_GET['delete_id'];
        $query = "SELECT image_url FROM overviews WHERE id = $delete_id";
        $result = $conn->query($query);
        $row = $result->fetch_assoc();
        $image_url = $row['image_url'];
        if (file_exists($image_url)) {
            unlink($image_url);
        }
        $delete_query = "DELETE FROM overviews WHERE id = $delete_id";
        $conn->query($delete_query);
        header("Location: overviews.php");
    }
    
    // Fetch data for editing
    $edit_id = isset($_GET['edit_id']) ? $_GET['edit_id'] : '';
    $edit_data = ["title" => "", "description" => "", "image_url" => ""];
    if ($edit_id) {
        $query = "SELECT * FROM overviews WHERE id='$edit_id'";
        $result = $conn->query($query);
        if ($result->num_rows > 0) {
            $edit_data = $result->fetch_assoc();
        }
    }

?>


<!DOCTYPE HTML>
<html>
<head>
    <meta charset="UTF-8" name="viewport" content="width=device-width, initial-scale=1"/>
    <link rel="stylesheet" type="text/css" href="css/bootstrap.css"/>
    <title>Manage Overviews</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="js/jquery-2.1.4.min.js"></script>
    <link href="css/bootstrap.min.css" rel='stylesheet' type='text/css' />
    <link href="css/style.css" rel='stylesheet' type='text/css' />
    <link rel="stylesheet" href="css/morris.css" type="text/css"/>
    <link href="css/font-awesome.css" rel="stylesheet">
    <script type="text/javascript" src="js/jquery.basictable.min.js"></script>
</head>
<body>
<div class="left-content">
    <div class="mother-grid-inner">
        <?php include('includes/header.php');?>
        <?php include('includes/sidebarmenu.php');?>
        <div class="clearfix"> </div>
    </div>

    <div class="container mt-5">
    <h1>Manage Overviews</h1>
    <form method="POST" enctype="multipart/form-data">
        <input type="hidden" name="edit_id" value="<?php echo $edit_id; ?>">
        <?php if ($edit_data['image_url']) { echo "<img src='{$edit_data['image_url']}' width='100'>"; } ?>
        <div class="form-group">
            <label for="image">Select Image</label>
            <input type="file" name="image" id="image" class="form-control">
        </div>
        <div class="form-group">
            <label for="title">Title</label>
            <input type="text" name="title" id="title" class="form-control" value="<?php echo $edit_data['title']; ?>" required>
        </div>
        <div class="form-group">
            <label for="description">Overviews</label>
            <textarea name="description" id="description" class="form-control" rows="3"><?php echo $edit_data['description']; ?></textarea>
        </div>
        <button type="submit" class="btn btn-primary"> <?php echo $edit_id ? 'Update' : 'Add'; ?> Overviews</button>
    </form>

        <hr>

        <!-- Display Existing Gallery Images -->
        <h2>Existing Overviews</h2>
        <table class="table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Image</th>
                    <th>Title</th>
                    <th>Overviews</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                  <?php
                // Fetch existing gallery images from the database
                $result = $conn->query("SELECT * FROM overviews");
                while ($row = $result->fetch_assoc()) {
                    echo "<tr>
                            <td>{$row['id']}</td>
                            <td><img src='{$row['image_url']}' width='100'></td>
                            <td>{$row['title']}</td>
                            <td>{$row['description']}</td>
                            <td>  <a href='overviews.php?edit_id={$row['id']}' class='btn btn-warning'>Edit</a>
                         
                                <a href='overviews.php?delete_id={$row['id']}' class='btn btn-danger' onclick='return confirm(\"Are you sure you want to delete this overviews?\")'>Delete</a>
                            </td>
                        </tr>";
                }}
                ?>
            </tbody>
        </table>
    </div>
</div>

<script src="js/jquery-3.2.1.min.js"></script>
<script src="js/bootstrap.js"></script>
<div class="clearfix"></div>		
							</div>
							<script>
							var toggle = true;
										
							$(".sidebar-icon").click(function() {                
							  if (toggle)
							  {
								$(".page-container").addClass("sidebar-collapsed").removeClass("sidebar-collapsed-back");
								$("#menu span").css({"position":"absolute"});
							  }
							  else
							  {
								$(".page-container").removeClass("sidebar-collapsed").addClass("sidebar-collapsed-back");
								setTimeout(function() {
								  $("#menu span").css({"position":"relative"});
								}, 400);
							  }
											
											toggle = !toggle;
										});
							</script>
</body>
</html>
